%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      CZPAnalyis.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file performs the post-processesing analysis of the CSP
%                 test.
%-------------------------------------------------------------------------------


%%
% Use the linear transformation derived from sensor space (above) to
% display the RGB image in the processor window.
vci = imageSet(vci,'colorConversionMethod','MCC Optimized');
vci = imageSet(vci,'colorBalanceMethod','Gray World'); 
vci = imageSet(vci,'internalCS','XYZ');


% First, compute with the default properties.  This uses bilinear
% demosaicing, no color conversion or balancing.  The sensor RGB values are
% simply set to the display RGB values.
vci = vcimageCompute(vci,sensor);
vcAddAndSelectObject(vci);
if (showISET == TRUE),
   vcimageWindow
end


% Plot the result
%%
img = vci.data.result;
img(img == NaN) = 0;
%img = img * 3;

figure();
imshow(img);

% End of File
